jQuery(document).ready(function($) {

	// Load the stats data

	$("#your-profile").prepend('<h3 id="' + nnr_as_stats_user_data.prefix_dash + 'author-stats">Author Stats</h3>');

	nnr_as_get_stats_data();

	// Date Change

	$(document).on('click', '.' + nnr_as_stats_user_data.prefix_dash + 'set-date', function(e){
		e.preventDefault();
		nnr_as_get_stats_data();
	});

	// Set All Time Date Range

	$(document).on('click', '.' + nnr_as_stats_user_data.prefix_dash + 'all-time', function(e){
		e.preventDefault();
		$('#' + nnr_as_stats_user_data.prefix_dash + 'start-date').val('01/01/1970');
		$('#' + nnr_as_stats_user_data.prefix_dash + 'end-date').val();

		$('.' + nnr_as_stats_user_data.prefix_dash + 'set-date').trigger('click');
	});

	/**
	 * Get the stats data
	 *
	 * @access public
	 * @return void
	 */
	function nnr_as_get_stats_data() {

		// Remove all current data

		var start_date = $('#' + nnr_as_stats_user_data.prefix_dash + 'start-date').val();
		var end_date = $('#' + nnr_as_stats_user_data.prefix_dash + 'end-date').val();
		var post_types = $('#' + nnr_as_stats_user_data.prefix_dash + 'post-types').val();

		$('.' + nnr_as_stats_user_data.prefix_dash + 'stats-wrap').remove();
		$('#' + nnr_as_stats_user_data.prefix_dash + 'author-stats').append('<div id="' + nnr_as_stats_user_data.prefix_dash + 'loading-stats" class="text-center"><i class="fa fa-5x fa-spinner fa-spin"></i></div>');

		$.post(ajaxurl, {
				'action': 'nnr_as_user_profile_stats',
				'start_date': start_date,
				'end_date': end_date,
				'post_types': post_types,
			}, function(response) {

			$("#" + nnr_as_stats_user_data.prefix_dash + "loading-stats").remove();
			$(response).insertAfter("#" + nnr_as_stats_user_data.prefix_dash + "author-stats");

			$($("." + nnr_as_stats_user_data.prefix_dash + "author-totals-container")).insertBefore("." + nnr_as_stats_user_data.prefix_dash + "form-filters");

			$($.bootstrapSortable);

			// Date Pickers

			if ($('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker').length != 0 &&
				$('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker').length != 0) {

				$('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'start-date')
					.datepicker({"dateFormat": "mm/dd/yy"});

				$('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date')
					.datepicker({"dateFormat": "mm/dd/yy"});

				$('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'start-date')
					.datepicker("option", "maxDate", '+0m +0w');

				$('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date')
					.datepicker("option", "maxDate", '+0m +0w');

				$('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date')
					.datepicker("option", "minDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'start-date').val() ));

				$('.input-group-addon').on('click', function(){
					$(this).closest('.date').find('input').focus();
				});

				$('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'start-date')
					.datepicker("option", "maxDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date').val() ));

				$('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date').on("change", function (e) {
					$('#' + nnr_as_stats_user_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'start-date')
						.datepicker("option", "maxDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_user_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_user_data.prefix_dash +'end-date').val() ));
				});
			}

			// Selectize

			var post_types_options = [];

		  	$.each(nnr_as_stats_user_data.post_types, function( index, value ) {
			  	post_types_options.push({id: index, name: value});

			});

			$('#' + nnr_as_stats_user_data.prefix_dash + 'post-types').selectize({
				plugins: ['remove_button'],
				delimiter: ',',
				persist: false,
				valueField: 'id',
				labelField: 'name',
				searchField: 'name',
				options: post_types_options,
			});
		});
	}
});
