jQuery(document).ready(function ($) {

    $(document).on('hover', '[data-toggle="tooltip"]', function () {
        $(this).tooltip();
    });

    // Load Stats Data

    $.post(ajaxurl, {
        'action': 'nnr_as_stats_load',
        'filter_metric': getQuerystring(nnr_as_stats_data.prefix_dash + 'filter-metric'),
        'start_date': getQuerystring(nnr_as_stats_data.prefix_dash + 'start-date'),
        'end_date': getQuerystring(nnr_as_stats_data.prefix_dash + 'end-date'),
        'post_types': getQuerystring(nnr_as_stats_data.prefix_dash + 'post-types'),
        'user_roles': getQuerystring(nnr_as_stats_data.prefix_dash + 'user-roles'),
        'author': getQuerystring('author'),
    }, function (response) {

        response = jQuery.parseJSON(response);

        $("#" + nnr_as_stats_data.prefix_dash + "loading-stats").remove();
        $("." + nnr_as_stats_data.prefix_dash + "stats-container").append(response.content);
        $($("." + nnr_as_stats_data.prefix_dash + "author-totals-container")).insertBefore("." + nnr_as_stats_data.prefix_dash + "form-filters");

        $($.bootstrapSortable);

    });

    // Date Pickers

    if ($('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker').length != 0 &&
        $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker').length != 0) {

        $('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_data.prefix_dash +'start-date')
            .datepicker({"dateFormat": "mm/dd/yy"});

        $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date')
            .datepicker({"dateFormat": "mm/dd/yy"});

        $('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_data.prefix_dash +'start-date')
            .datepicker("option", "maxDate", '+0m +0w');

        $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date')
            .datepicker("option", "maxDate", '+0m +0w');

        $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date')
            .datepicker("option", "minDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_data.prefix_dash +'start-date').val() ));

        $('.input-group-addon').on('click', function(){
           $(this).closest('.date').find('input').focus();
        });

        $('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_data.prefix_dash +'start-date')
            .datepicker("option", "maxDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date').val() ));

        $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date').on("change", function (e) {
            $('#' + nnr_as_stats_data.prefix_dash + 'start-datepicker #'+ nnr_as_stats_data.prefix_dash +'start-date')
                .datepicker("option", "maxDate", $.datepicker.parseDate( "mm/dd/yy", $('#' + nnr_as_stats_data.prefix_dash + 'end-datepicker #'+ nnr_as_stats_data.prefix_dash +'end-date').val() ));
        });
    }

    // Selectize

    var post_types_options = [];

    $.each(nnr_as_stats_data.post_types, function (index, value) {
        post_types_options.push({id: index, name: value});

    });

    $('#' + nnr_as_stats_data.prefix_dash + 'post-types').selectize({
        plugins: ['remove_button'],
        delimiter: ',',
        persist: false,
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        options: post_types_options,
    });

    // User Roles

    var user_roles_options = [];
    $.each(nnr_as_stats_data.user_roles, function (index, value) {
        user_roles_options.push({id: value, name: value});
    });

    $('#' + nnr_as_stats_data.prefix_dash + 'user-roles').selectize({
        plugins: ['remove_button'],
        delimiter: ',',
        persist: false,
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        options: user_roles_options,
    });

    show_quick_info();

    /**
     * Show the filters next to the button
     *
     * @access public
     * @return void
     */
    function show_quick_info() {

        var filter_metric = '<span class="' + nnr_as_stats_data.prefix_dash +
            'quick-info-label">Filter Metric:</span> ' +
            $('#' + nnr_as_stats_data.prefix_dash + 'filter-metric').val();

        var start_date = '<span class="' + nnr_as_stats_data.prefix_dash +
            'quick-info-label">Start Date:</span> ' +
            $('#' + nnr_as_stats_data.prefix_dash + 'start-date').val();

        var end_date = '<span class="' + nnr_as_stats_data.prefix_dash +
            'quick-info-label">End Date:</span> ' +
            $('#' + nnr_as_stats_data.prefix_dash + 'end-date').val();

        var post_types = '<span class="' + nnr_as_stats_data.prefix_dash +
            'quick-info-label">Post Types:</span> ' +
            $('#' + nnr_as_stats_data.prefix_dash + 'post-types').val();

        var user_roles = '';

        if ($('#' + nnr_as_stats_data.prefix_dash + 'user-roles').length != 0) {
            user_roles = ' | <span class="' + nnr_as_stats_data.prefix_dash +
                'quick-info-label">User Roles:</span> ' +
                $('#' + nnr_as_stats_data.prefix_dash + 'user-roles').val();
        }

        $('.' + nnr_as_stats_data.prefix_dash + 'quick-info').html(filter_metric + ' | ' + start_date + ' | ' + end_date + ' | ' + post_types + user_roles);

    }

    /**
     * Gets a query parameter
     *
     * @access public
     * @param mixed key
     * @param mixed default_
     * @return void
     */
    function getQuerystring(key, default_) {
        if (default_ == null) default_ = "";
        key = key.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regex = new RegExp("[\\?&]" + key + "=([^&#]*)");
        var qs = regex.exec(window.location.href);
        if (qs == null)
            return default_;
        else
            return qs[1];
    }
});
