jQuery(document).ready(function($){

	// 1. when dropped in
	$('div.widgets-sortables').on('sortstop',function(event,ui){
		nnr_as_setup_selectize();
	});

	// 2. do some stuff on load
	nnr_as_setup_selectize();

	// 3. on action
	$('.our_widget_class').on('change', function(ev) {
		// you have to find the parent widget here,
		// and do something for it. And this is not easy
		// because the widget shouldn't have it's ID yet, but still possible.
		// This is actually the safest part of the whole process (maybe just for me)
		nnr_as_setup_selectize();
	});

	// 4. on save
	$('body').ajaxSuccess(function(evt, request, settings) {
		nnr_as_setup_selectize();
	});


  	/**
  	 * Sets up all the selectize values
  	 *
  	 * @access public
  	 * @return void
  	 */
  	function nnr_as_setup_selectize() {

		// Selectize - Post Types

		var post_types_options = [];

	  	$.each(nnr_as_widget_data.post_types, function( index, value ) {
		  	post_types_options.push({id: index, name: value});

		});

		$('.' + nnr_as_widget_data.prefix_dash + 'post-types').selectize({
			plugins: ['remove_button'],
			delimiter: ',',
			persist: false,
			valueField: 'id',
			labelField: 'name',
			searchField: 'name',
			options: post_types_options,
		});

		// Selectize - User Roles

		var user_roles_options = [];
	  	$.each(nnr_as_widget_data.user_roles, function( index, value ) {
		  	user_roles_options.push({id: value, name: value});
		});

		$('.' + nnr_as_widget_data.prefix_dash + 'user-roles').selectize({
			plugins: ['remove_button'],
			delimiter: ',',
			persist: false,
			valueField: 'id',
			labelField: 'name',
			searchField: 'name',
			options: user_roles_options,
		});
  	}
});