<div class="nnr-wrap">

    <?php require_once('header.php'); ?>

    <div class="nnr-container">
        <?php
        $indexed = get_transient('nnr_as_indexed_posts');

        if ($indexed) {
            global $wpdb;
            $nnr_total_post_query = new WP_Query(array(
                'post_type' => 'any',
                'post_status' => 'publish'
            ));

            $indexed_post_counts = $wpdb->get_row("SELECT count(*) as 'post_count' FROM " . $wpdb->prefix . "nnr_as_indexed_posts");
            ?>
            <p class="nnr-notice alert alert-warning">
                <span class="pull-left nnr-index-posts-message"><?php _e('We are indexing posts....'); ?></span>
                <span class="pull-right nnr-index-posts-message">
                    Status: <?php echo $indexed_post_counts->post_count; ?> of <?php echo $nnr_total_post_query->found_posts; ?> indexed ( <i class="fa fa-x fa-refresh"></i> <a href="">refresh status</a> )
                </span>
            </p>
            <div class="clearfix"></div>
            <?php
        }
        ?>

        <?php if (isset($_GET['error_message']) && $_GET['error_message'] != '') { ?>
            <div class="alert alert-<?php echo(isset($_GET['status']) && $_GET['status'] != '' ? $_GET['status'] : 'warning'); ?> alert-dismissible fade in"
                 role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span
                            aria-hidden="true">×</span></button>
                <?php echo urldecode($_GET['error_message']); ?>
            </div>
        <?php } ?>

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active"><a href="#<?php echo self::$prefix_dash; ?>stats"
                                                      aria-controls="home" role="tab"
                                                      data-toggle="tab"><?php _e('Stats', self::$text_domain); ?></a>
            </li>
            <li role="presentation"><a href="#<?php echo self::$prefix_dash; ?>settings" aria-controls="profile"
                                       role="tab" data-toggle="tab"><?php _e('Settings', self::$text_domain); ?></a>
            </li>
            <li role="presentation"><a href="#<?php echo self::$prefix_dash; ?>shortcode" aria-controls="home"
                                       role="tab" data-toggle="tab"><?php _e('Shortcode', self::$text_domain); ?></a>
            </li>
            <li role="presentation"><a href="#<?php echo self::$prefix_dash; ?>updates" aria-controls="profile"
                                       role="tab" data-toggle="tab"><?php _e('Updates', self::$text_domain); ?></a></li>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">

            <div role="tabpanel" class="tab-pane active" id="<?php echo self::$prefix_dash; ?>stats"
                 style="position:relative;">

                <h2 id="nnr-heading"><?php _e("Stats", self::$text_domain); ?>
                    <small>
                        <div class="nnr-heading-button-left">
                            <?php if (isset($_GET['author']) && $_GET['author'] != '') { ?>
                                <a href="<?php echo get_admin_url() . 'users.php?page=' . self::$settings_page; ?>"
                                   class="pull-left btn btn-primary" style="margin-right: 15px;"><i
                                            class="fa fa-long-arrow-left"></i> <?php _e("Back", self::$text_domain); ?>
                                </a>
                            <?php } ?>
                        </div>

                        <a href="<?php echo wp_nonce_url(get_admin_url() . 'users.php?page=' . self::$settings_page . '&export_data=true&author=' . (isset($_GET['author']) ? $_GET['author'] : '') . '&' . self::$prefix_dash . 'filter-metric=' . (!empty($_GET[self::$prefix_dash . 'filter-metric']) ? urldecode($_GET[self::$prefix_dash . 'filter-metric']) : 'posts') . '&' . self::$prefix_dash . 'start-date=' . $start_date . '&' . self::$prefix_dash . 'end-date=' . $end_date . '&' . self::$prefix_dash . 'post-types=' . (isset($_GET[self::$prefix_dash . 'post-types']) && $_GET[self::$prefix_dash . 'post-types'] != '' ? urldecode($_GET[self::$prefix_dash . 'post-types']) : implode(',', $post_types)) . '&' . self::$prefix_dash . 'user-roles=' . (isset($_GET[self::$prefix_dash . 'user-roles']) && $_GET[self::$prefix_dash . 'user-roles'] != '' ? urldecode($_GET[self::$prefix_dash . 'user-roles']) : implode(',', $roles)), self::$prefix . 'export_data'); ?>"
                           class="nnr-heading-button-right pull-right btn btn-default"><i
                                    class="fa fa-download"></i> <?php _e("Export to CSV", self::$text_domain); ?></a>

                    </small>
                </h2>

                <form method="get" role="form" class="<?php echo self::$prefix_dash; ?>form-filters">

                    <button type="button" class="btn btn-info pull-left" data-toggle="modal"
                            data-target="#<?php echo self::$prefix_dash; ?>advanced-settings"><i
                                class="fa fa-cogs"></i> <?php _e("Filters", self::$text_domain); ?></button>

                    <div class="modal fade" style="z-index: 99999;"
                         id="<?php echo self::$prefix_dash; ?>advanced-settings" tabindex="-1" role="dialog"
                         aria-labelledby="myModalLabel">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                                aria-hidden="true">&times;</span></button>
                                    <h4 class="modal-title"
                                        id="myModalLabel"><?php _e("Advanced Settings", self::$text_domain); ?></h4>
                                </div>
                                <div class="modal-body" style="min-height: 300px;">

                                    <!-- Filter By -->
                                    <label class="control-label">
                                        <?php _e("Filter Metric", self::$text_domain); ?> <em>(<a
                                                    href="https://draftpress.com/docs/author-stats-pro/"
                                                    target="_blank">more help</a>)</em>
                                    </label>
                                    <div class="form-group">
                                        <?php
                                        $nnr_filter_metric = "posts";
                                        $nnr_filter_metric_options = ['posts' => 'Posts', 'views' => 'Views & Comments'];
                                        if (!empty($_GET[self::$prefix_dash . 'filter-metric'])) {
                                            $nnr_filter_metric = urldecode($_GET[self::$prefix_dash . 'filter-metric']);
                                        }
                                        ?>
                                        <select class="" id="<?php echo self::$prefix_dash; ?>filter-metric"
                                                name="<?php echo self::$prefix_dash; ?>filter-metric">
                                            <?php foreach ($nnr_filter_metric_options as $nnr_key => $nnr_option) { ?>
                                                <?php if ($nnr_filter_metric == $nnr_key) { ?>
                                                    <option value="<?php echo $nnr_key; ?>" selected="selected">
                                                        <?php echo $nnr_option; ?>
                                                    </option>
                                                <?php } else { ?>
                                                    <option value="<?php echo $nnr_key; ?>"><?php echo $nnr_option; ?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                        <em class="help-block">
                                            <ul>
                                                <li><?php _e("Posts (Includes ONLY posts published within the date range)", self::$text_domain); ?></li>
                                                <li><?php _e("Views (Includes ALL posts but ONLY Views/Comments received within the date range)", self::$text_domain); ?></li>
                                            </ul>
                                        </em>
                                    </div>

                                    <!-- Start Date -->

                                    <label class="control-label"><?php _e("Start Date", self::$text_domain); ?></label>

                                    <div class="input-group date <?php echo self::$prefix_dash; ?>export-start-datepicker"
                                         id="<?php echo self::$prefix_dash; ?>start-datepicker">
                                        <input id="<?php echo self::$prefix_dash; ?>start-date"
                                               name="<?php echo self::$prefix_dash; ?>start-date" type='text'
                                               class="form-control" value="<?php echo $start_date; ?>"/>
                                        <span class="input-group-addon"><span
                                                    class="glyphicon glyphicon-calendar"></span>
										</span>
                                    </div>

                                    <em class="help-block"><?php _e("Select the start date to filter the selected metric.", self::$text_domain); ?></em>

                                    <!-- End Date -->

                                    <label class="control-label"><?php _e("End Date", self::$text_domain); ?></label>

                                    <div class="input-group date <?php echo self::$prefix_dash; ?>export-end-datepicker"
                                         id="<?php echo self::$prefix_dash; ?>end-datepicker">
                                        <input id="<?php echo self::$prefix_dash; ?>end-date"
                                               name="<?php echo self::$prefix_dash; ?>end-date" type='text'
                                               class="form-control" value="<?php echo $end_date; ?>"/>
                                        <span class="input-group-addon"><span
                                                    class="glyphicon glyphicon-calendar"></span>
										</span>
                                    </div>

                                    <em class="help-block"><?php _e("Select the end date to filter the selected metric.", self::$text_domain); ?></em>

                                    <!-- Post Types -->

                                    <label for="<?php echo self::$prefix_dash; ?>post-types"
                                           class="control-label"><?php _e("Post Types", self::$text_domain); ?></label>
                                    <div class="form-group">
                                        <input type="text" id="<?php echo self::$prefix_dash; ?>post-types"
                                               name="<?php echo self::$prefix_dash; ?>post-types"
                                               class="form-control pull-left"
                                               value="<?php echo(isset($_GET[self::$prefix_dash . 'post-types']) && $_GET[self::$prefix_dash . 'post-types'] != '' ? urldecode($_GET[self::$prefix_dash . 'post-types']) : implode(',', $post_types)); ?>">
                                        <em class="help-block"><?php _e("Which post types should be in included in the stats data.", self::$text_domain); ?></em>
                                    </div>

                                    <?php if (!isset($_GET['author']) || (isset($_GET['author']) && $_GET['author'] == '')) { ?>

                                        <!-- User Roles-->

                                        <label for="<?php echo self::$prefix_dash; ?>post-types"
                                               class="control-label"><?php _e("User Roles", self::$text_domain); ?></label>
                                        <div class="form-group">
                                            <input type="text" id="<?php echo self::$prefix_dash; ?>user-roles"
                                                   name="<?php echo self::$prefix_dash; ?>user-roles"
                                                   class="form-control"
                                                   value="<?php echo(isset($_GET[self::$prefix_dash . 'user-roles']) && $_GET[self::$prefix_dash . 'user-roles'] != '' ? urldecode($_GET[self::$prefix_dash . 'user-roles']) : implode(',', $roles)); ?>">
                                            <em class="help-block"><?php _e("Which user roles should be in included in the stats data.", self::$text_domain); ?></em>
                                        </div>

                                    <?php } ?>

                                </div>
                                <div class="modal-footer">
                                    <a href="<?php echo get_admin_url() . 'users.php?page=' . self::$settings_page . '&' . self::$prefix_dash . 'start-date=01%2F01%2F1970' . (isset($_GET['author']) ? '&author=' . $_GET['author'] : '') . '&' . self::$prefix_dash . 'post-types=' . (isset($_GET[self::$prefix_dash . 'post-types']) && $_GET[self::$prefix_dash . 'post-types'] != '' ? urldecode($_GET[self::$prefix_dash . 'post-types']) : implode(',', $post_types)) . '&' . self::$prefix_dash . 'user-roles=' . (isset($_GET[self::$prefix_dash . 'user-roles']) && $_GET[self::$prefix_dash . 'user-roles'] != '' ? urldecode($_GET[self::$prefix_dash . 'user-roles']) : implode(',', $roles)); ?>"
                                       class="btn btn-default <?php echo self::$prefix_dash; ?>all-time"><i
                                                class="fa fa-clock-o"></i> <?php _e("All Time", self::$text_domain); ?>
                                    </a>

                                    <button type="submit" class="btn btn-info"><i
                                                class="fa fa-filter"></i> <?php _e("Apply", self::$text_domain); ?>
                                    </button>
                                    <button class="btn btn-default pull-left"
                                            data-dismiss="modal"><?php _e("Cancel", self::$text_domain); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input class="hidden" name="page" value="<?php echo self::$settings_page; ?>"/>
                    <input class="hidden" name="author"
                           value="<?php echo(isset($_GET['author']) ? $_GET['author'] : ''); ?>"/>

                    <span class="<?php echo self::$prefix_dash; ?>quick-info"></span>

                </form>


                <div class="clearfix"></div>

                <div id="<?php echo self::$prefix_dash; ?>loading-stats" class="text-center">
                    <i class="fa fa-5x fa-spinner fa-spin"></i>
                </div>

                <div class="<?php echo self::$prefix_dash; ?>stats-container">

                </div>

            </div>

            <div role="tabpanel" class="tab-pane" id="<?php echo self::$prefix_dash; ?>settings">

                <form class="form-horizontal" method="post">

                    <h2 id="nnr-heading">
                        <?php _e("Settings", self::$text_domain); ?>
                        <small>
                            <button type="submit" name="submit-settings"
                                    class="btn btn-info pull-right nnr-heading-button-right"><i
                                        class="fa fa-hdd-o"></i> <?php _e("Save", self::$text_domain); ?></button>
                        </small>
                    </h2>

                    <div class="form-group">
                        <label for="<?php echo self::$prefix_dash; ?>use-shared-count"
                               class="col-sm-3 control-label"><?php _e("User Role Visibility", self::$text_domain); ?></label>
                        <div class="col-sm-9">

                            <?php foreach ($wp_roles->roles as $wp_role) {

                                if (isset($wp_role['capabilities']['edit_posts']) && $wp_role['capabilities']['edit_posts']) {
                                    $role = str_replace(' ', '', strtolower($wp_role['name'])); ?>

                                    <input type="checkbox"
                                           class="<?php echo self::$prefix_dash; ?>user-role-<?php echo $role; ?>"
                                           id="<?php echo self::$prefix_dash; ?>user-role-<?php echo $role; ?>"
                                           name="<?php echo self::$prefix_dash; ?>user-role-<?php echo $role; ?>" <?php echo isset($settings['user_role_' . $role]) && $settings['user_role_' . $role] ? 'checked="checked"' : ''; ?>>
                                    <label for="<?php echo self::$prefix_dash; ?>user-role-<?php echo $role; ?>">
							            <span class="fa-stack fa-lg">
							                <i class="fa fa-square-o fa-stack-1x"></i>
							                <i class="fa fa-check fa-stack-1x"></i>
							            </span>
                                    </label>
                                    <span><?php echo $wp_role['name']; ?></span>
                                    <br/>
                                <?php }
                            } ?>

                            <em class="help-block"><?php _e("Which users can see their own stats on their profile page.", self::$text_domain); ?></em>
                        </div>
                    </div>

                    <?php wp_nonce_field(self::$prefix . 'admin_settings'); ?>

                </form>

                <div class="panel-group" role="tablist" aria-multiselectable="true">
                    <div class="panel panel-danger">
                        <div class="panel-heading">
                            <a style="color:black;" class="collapsed" role="button" data-toggle="collapse"
                               href="#<?php echo self::$prefix_dash; ?>reset-stats-collapse" aria-expanded="false"
                               aria-controls="collapseThree"><?php _e("Reset View Stats", self::$text_domain); ?></a>
                        </div>
                        <div id="<?php echo self::$prefix_dash; ?>reset-stats-collapse" class="panel-collapse collapse"
                             role="tabpanel">

                            <div class="panel-body">
                                <div class="modal fade" id="<?php echo self::$prefix_dash; ?>reset-stats-modal"
                                     tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal"
                                                        aria-label="Close"><span aria-hidden="true">&times;</span>
                                                </button>
                                                <h4 class="modal-title"
                                                    id="myModalLabel"><?php _e("Are you sure?", self::$text_domain); ?></h4>
                                            </div>
                                            <div class="modal-body">
                                                <p><?php _e("By resetting the view stats you will delete <strong>ALL</strong> views data that this plugin collects and that data cannot be restored.", self::$text_domain); ?></p>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default"
                                                        data-dismiss="modal"><?php _e("Close", self::$text_domain); ?></button>
                                                <a role="button"
                                                   href="<?php echo get_admin_url() . 'users.php?page=' . self::$settings_page . '&action=reset-stats'; ?>"
                                                   class="btn btn-danger"><i
                                                            class="fa fa-exclamation-triangle"></i> <?php _e("Reset View Stats", self::$text_domain); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <p><?php _e("Resetting the view stats will delete all views data that this plugin collects.  This will NOT affect any data on your site and all other stats will remain the same except for views data.", self::$text_domain); ?></p>

                                <button type="button" class="btn btn-danger" data-toggle="modal"
                                        data-target="#<?php echo self::$prefix_dash; ?>reset-stats-modal"><i
                                            class="fa fa-exclamation-triangle"></i> <?php _e("Reset", self::$text_domain); ?>
                                </button>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="alert alert-warning">
                    <b>NOTE:</b> If you delete this plugin, all Author Stats generated data and tables will be deleted to ensure data integrity and keep your WP database clean.
                </div>

            </div>

            <div role="tabpanel" class="tab-pane" id="<?php echo self::$prefix_dash; ?>shortcode">

                <h2 id="nnr-heading"><?php _e("Shortcode", self::$text_domain); ?></h2>

                <p><?php _e("Insert <code>[nnr_author_leaderboard]</code> wherever you want to show an interactive author leaderboard on your site.  the author leaderboard will look like the All Authors Stats page.", self::$text_domain); ?></p>

            </div>

            <div role="tabpanel" class="tab-pane" id="<?php echo self::$prefix_dash; ?>updates">

                <h2 id="nnr-heading"><?php _e("Updates", self::$text_domain); ?></h2>

                <div class="form-horizontal">

                    <div class="form-group has-feedback <?php echo self::$prefix_dash; ?>license-key-feedback">
                        <label class="control-label col-sm-3"><?php _e("License Key", self::$text_domain); ?></label>

                        <div class="col-sm-9">
                            <div class="col-sm-8" style="padding-left:0px;">
                                <input type="text" class="form-control <?php echo self::$prefix_dash; ?>license-key"
                                       value="<?php echo $license_key; ?>"
                                       placeholder="<?php _e('Enter your License Key', self::$text_domain); ?>"/>
                            </div>
                        </div>

                    </div>

                    <!-- Check PHP Version -->

                    <?php if (version_compare(phpversion(), NNROBOTS_AUTHOR_STATS_MIN_PHP_VERSION) < 1) { ?>

                        <div class="form-group has-feedback has-error">
                            <label class="col-sm-3 control-label"><?php _e("PHP Version Info", self::$text_domain); ?></label>
                            <div class="col-sm-9">
                                <p class="form-control-static"
                                   style="color:#a94442;"><?php _e('The required minimum version of PHP is <strong>v' . NNROBOTS_AUTHOR_STATS_MIN_PHP_VERSION . '</strong> and your version is <strong>v' . phpversion() . '</strong>. Your version of PHP is outdated and we strongly recommend that you <a href="https://99robots.com/?p=7356" target="_blank">update</a> your version of PHP to at least <strong>v' . NNROBOTS_AUTHOR_STATS_MIN_PHP_VERSION . '</strong>.', self::$text_domain); ?></p>
                            </div>
                        </div>

                    <?php } else { ?>

                        <div class="form-group">
                            <label class="col-sm-3 control-label"><?php _e("PHP Version Info", self::$text_domain); ?></label>
                            <div class="col-sm-9">
                                <p class="form-control-static"><?php _e('The required minimum version of PHP is <strong>v' . NNROBOTS_AUTHOR_STATS_MIN_PHP_VERSION . '</strong> and your version is <strong>v' . phpversion() . '</strong>. You have a sufficient version of a PHP.', self::$text_domain); ?></p>
                            </div>
                        </div>

                    <?php } ?>

                    <!-- Display WordPress and Plguin Version -->

                    <div class="form-group">
                        <label class="col-sm-3 control-label"><?php _e("Version Info", self::$text_domain); ?></label>
                        <div class="col-sm-9">
                            <p class="form-control-static"><?php _e("You are currently running " . NNROBOTS_AUTHOR_STATS_ITEM_NAME . "  <strong>v" . NNROBOTS_AUTHOR_STATS_VERSION_NUM . "</strong> on WordPress <strong>v" . $wp_version . '</strong>', self::$text_domain); ?></p>
                        </div>
                    </div>

                </div>

            </div>

        </div>

    </div>

    <?php require_once('footer.php'); ?>

</div>
