jQuery(document).ready(function($) {

	// Load the stats data

	nnr_as_get_stats_data();

	// Date Change

	$(document).on('click', '.' + nnr_as_data.prefix_dash + 'set-date', function(e){
		e.preventDefault();
		nnr_as_get_stats_data();
	});

	// Set All Time Date Range

	$(document).on('click', '.' + nnr_as_data.prefix_dash + 'all-time', function(e){
		e.preventDefault();
		$('#' + nnr_as_data.prefix_dash + 'start-date').val('01/01/1970');
		$('#' + nnr_as_data.prefix_dash + 'end-date').val();

		$('.' + nnr_as_data.prefix_dash + 'set-date').trigger('click');
	});

	/**
	 * Get the stats data
	 *
	 * @access public
	 * @return void
	 */
	function nnr_as_get_stats_data() {

		// Remove all current data

		var start_date = $('#' + nnr_as_data.prefix_dash + 'start-date').val();
		var end_date   = $('#' + nnr_as_data.prefix_dash + 'end-date').val();
		var post_types = $('#' + nnr_as_data.prefix_dash + 'post-types').val();
		var user_roles = $('#' + nnr_as_data.prefix_dash + 'user-roles').val();

		$('.' + nnr_as_data.prefix_dash + 'table-container').remove();
		$('.' + nnr_as_data.prefix_dash + 'shortcode-wrap').append('<div id="' + nnr_as_data.prefix_dash + 'loading-stats" class="text-center"><i class="fa fa-5x fa-spinner fa-spin"></i></div>');

		$.post(nnr_as_data.ajaxurl, {
				'action': 'nnr_as_stats_load',
				'start_date': start_date,
				'end_date': end_date,
				'post_types': post_types,
				'user_roles': user_roles,
				'author': null,
			}, function(response) {

			response = $.parseJSON(response);

			$("#" + nnr_as_data.prefix_dash + "loading-stats").remove();
			$('.' + nnr_as_data.prefix_dash + 'shortcode-wrap').append(response.content);

			console.log(response.content);

			// Remove stats link

			$('.' + nnr_as_data.prefix_dash + 'row-actions').remove();

			// Date Pickers

			if ($('#' + nnr_as_data.prefix_dash + 'start-datepicker').length != 0 &&
				$('#' + nnr_as_data.prefix_dash + 'end-datepicker').length != 0) {

				$('#' + nnr_as_data.prefix_dash + 'start-datepicker').datetimepicker({
			        format: 'MM/DD/YYYY'
			    });

				$('#' + nnr_as_data.prefix_dash + 'end-datepicker').datetimepicker({
			        format: 'MM/DD/YYYY'
			    });

				$('#' + nnr_as_data.prefix_dash + 'end-datepicker')
					.data("DateTimePicker")
					.maxDate( moment(nnr_as_data.today, "M/D/Y") );

				$('#' + nnr_as_data.prefix_dash + 'start-datepicker')
					.data("DateTimePicker")
					.maxDate( moment(nnr_as_data.today, "M/D/Y") );

				$('#' + nnr_as_data.prefix_dash + 'end-datepicker')
					.data("DateTimePicker")
					.minDate( $('#' + nnr_as_data.prefix_dash + 'start-datepicker').data("DateTimePicker").date() );

				$('#' + nnr_as_data.prefix_dash + 'start-datepicker').on("dp.change",function (e) {
			       $('#' + nnr_as_data.prefix_dash + 'end-datepicker').data("DateTimePicker").minDate(e.date);
			    });

			    $('#' + nnr_as_data.prefix_dash + 'end-datepicker').on("dp.change",function (e) {
			       $('#' + nnr_as_data.prefix_dash + 'start-datepicker').data("DateTimePicker").maxDate(e.date);
			    });
			}

			// Post Types

			var post_types_options = [];

		  	$.each(nnr_as_data.post_types, function( index, value ) {
			  	post_types_options.push({id: index, name: value});

			});

			$('#' + nnr_as_data.prefix_dash + 'post-types').selectize({
				plugins: ['remove_button'],
				delimiter: ',',
				persist: false,
				valueField: 'id',
				labelField: 'name',
				searchField: 'name',
				options: post_types_options,
			});

			// User Roles

			var user_roles_options = [];
		  	$.each(nnr_as_data.user_roles, function( index, value ) {
			  	user_roles_options.push({id: value, name: value});
			});

			$('#' + nnr_as_data.prefix_dash + 'user-roles').selectize({
				plugins: ['remove_button'],
				delimiter: ',',
				persist: false,
				valueField: 'id',
				labelField: 'name',
				searchField: 'name',
				options: user_roles_options,
			});

			$($.bootstrapSortable);

		});
	}
});
