<?php

/**
 * reate shortcode [nnr_as_leaderboard]
 *
 * @access public
 * @param mixed $atts
 * @return void
 */
function nnr_as_leaderboard_shortcode($atts) {

	// Do not display if this is not a singular post

	if ( !is_singular() ) {
		return;
	}

	// Style

	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'settings_css', 					NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/settings.css');
	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'bootstrap_css', 					NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/nnr-bootstrap.min.css');
	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'fontawesome_css',				NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/include/fontawesome/css/font-awesome.min.css');
	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'bootstrap_sortable_css', 		NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/bootstrap-sortable.css');
	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'bootstrap_datetimepicker_css',	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/bootstrap-datetimepicker.min.css');
	wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'bootstrap_selectize_css', 		NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/selectize.bootstrap3.css');

	// Scripts

	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'bootstrap_js', 					NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/bootstrap.min.js', array('jquery'));
	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'bootstrap_sortable_js', 		NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/bootstrap-sortable.js', array('jquery'));
	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'bootstrap_moment_js', 			NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/moment.js', array('jquery'));
	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'bootstrap_selectize_js', 		NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/selectize.min.js', array('jquery'));
	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'bootstrap_datetimepicker_js', 	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/bootstrap-datetimepicker.min.js', array('jquery', NNRobots_Author_Stats::$prefix . 'bootstrap_moment_js'));

	// User Roles

	global $wp_roles;
	$roles = array();

	foreach ( $wp_roles->roles as $role ) {

		$role['name'] = str_replace('|User role', '', $role['name']);

		if ( isset($role['capabilities']['edit_posts']) && $role['capabilities']['edit_posts'] ) {
			$roles[] = $role['name'];
		}

	}

	wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'stats_shortcode_js', 			NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/core/js/author-stats.js', array('jquery'));
	wp_localize_script(NNRobots_Author_Stats::$prefix . 'stats_shortcode_js', 			'nnr_as_data', array(
		'prefix_dash'			=> NNRobots_Author_Stats::$prefix_dash,
		'ajaxurl'				=> admin_url( 'admin-ajax.php' ),
		'today'					=> date('m/d/Y'),
		'post_types'			=> get_post_types(array('public' => true), 'names'),
		'user_roles'			=> $roles,
	));

	// Format dates

	$start_date = isset($_POST["start_date"]) && $_POST["start_date"] != '' ?
					date('m/d/Y', strtotime($_POST["start_date"])) :
					date('m/d/Y', mktime(0, 0, 0, date("m"), date("d"), date("Y")-1));

	$end_date = isset($_POST["end_date"]) && $_POST["end_date"] != '' ?
					date('m/d/Y', strtotime($_POST["end_date"])) :
					date("m/d/Y", strtotime(current_time('mysql')));

	// Post Types

	if ( isset($_POST['post_types']) && $_POST['post_types'] != '' ) {
		$post_types = explode(',', urldecode($_POST['post_types']));
	} else {
		$post_types = array('post');//get_post_types(array('public' => true), 'names');
	}

	// User Roles

	global $wp_roles;
	$roles = array();

	if ( isset($_POST['user_roles']) && $_POST['user_roles'] != '' ) {
		$roles = explode(',', urldecode($_POST['user_roles']));
	} else {
		foreach ( $wp_roles->roles as $role ) {

			$role['name'] = str_replace('|User role', '', $role['name']);

			if ($role['name'] == 'Administrator' ||
				$role['name'] == 'Editor' ||
				$role['name'] == 'Author' ||
				$role['name'] == 'Contributor' ||
				$role['name'] == 'Super Admin' ) {

				$roles[] = $role['name'];
			}
		}
	}

	$content = '<div style="margin-right:0;" class="nnr-wrap ' . NNRobots_Author_Stats::$prefix_dash . 'shortcode-wrap">
		<form method="get" role="form" class="' . NNRobots_Author_Stats::$prefix_dash . 'form-filters">

			<button type="button" class="btn btn-default pull-left" data-toggle="modal" data-target="#' . NNRobots_Author_Stats::$prefix_dash . 'advanced-settings"><i class="fa fa-cogs"></i> ' . __("Filters", NNRobots_Author_Stats::$text_domain) . '</button>

			<div class="modal fade" style="z-index: 99999;" id="' . NNRobots_Author_Stats::$prefix_dash . 'advanced-settings" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
				<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="myModalLabel">' . __("Advanced Settings", NNRobots_Author_Stats::$text_domain) . '</h4>
						</div>
						<div class="modal-body" style="min-height: 300px;">

							<!-- Start Date -->

							<label class="control-label">' . __("Start Date", NNRobots_Author_Stats::$text_domain) . '</label>

							<div class="input-group date ' . NNRobots_Author_Stats::$prefix_dash . 'export-start-datepicker" id="' . NNRobots_Author_Stats::$prefix_dash . 'start-datepicker">
								<input id="' . NNRobots_Author_Stats::$prefix_dash . 'start-date" name="' . NNRobots_Author_Stats::$prefix_dash . 'start-date" type="text" class="form-control" value="' . $start_date . '"/>
								<span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
								</span>
							</div>

							<em class="help-block">' . __("Select the start date to filter views and comments. Note: This will not filter posts by publish date", NNRobots_Author_Stats::$text_domain) . '</em>


							<!-- End Date -->

							<label class="control-label">' . __("End Date", NNRobots_Author_Stats::$text_domain) . '</label>

							<div class="input-group date ' . NNRobots_Author_Stats::$prefix_dash . 'export-end-datepicker" id="' . NNRobots_Author_Stats::$prefix_dash . 'end-datepicker">
								<input id="' . NNRobots_Author_Stats::$prefix_dash . 'end-date" name="' . NNRobots_Author_Stats::$prefix_dash . 'end-date" type="text" class="form-control" value="' . $end_date . '"/>
								<span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
								</span>
							</div>

							<em class="help-block">' . __("Select the end date to filter views and comments. Note: This will not filter posts by publish date", NNRobots_Author_Stats::$text_domain) . '</em>

							<!-- Post Types -->

							<label for="' . NNRobots_Author_Stats::$prefix_dash . 'post-types" class="control-label">' . __("Post Types", NNRobots_Author_Stats::$text_domain) . '</label>
							<div class="form-group">
								<input type="text" id="' . NNRobots_Author_Stats::$prefix_dash . 'post-types" name="' . NNRobots_Author_Stats::$prefix_dash . 'post-types" class="form-control pull-left" value="' . (isset($_GET[NNRobots_Author_Stats::$prefix_dash . 'post-types']) && $_GET[NNRobots_Author_Stats::$prefix_dash . 'post-types'] != '' ? urldecode($_GET[NNRobots_Author_Stats::$prefix_dash . 'post-types']) : implode(',', $post_types)) . '">
								<em class="help-block">' . __("Which post types should be in included in the stats data.", NNRobots_Author_Stats::$text_domain) . '</em>
							</div>

							<!-- User Roles-->

							<label for="' . NNRobots_Author_Stats::$prefix_dash . 'post-types" class="control-label">' . __("User Roles", NNRobots_Author_Stats::$text_domain) . '</label>
							<div class="form-group">
								<input type="text" id="' . NNRobots_Author_Stats::$prefix_dash . 'user-roles" name="' . NNRobots_Author_Stats::$prefix_dash . 'user-roles" class="form-control" value="' . (isset($_GET[NNRobots_Author_Stats::$prefix_dash . 'user-roles']) && $_GET[NNRobots_Author_Stats::$prefix_dash . 'user-roles'] != '' ? urldecode($_GET[NNRobots_Author_Stats::$prefix_dash . 'user-roles']) : implode(',', $roles)) . '">
								<em class="help-block">' . __("Which user roles should be in included in the stats data.", NNRobots_Author_Stats::$text_domain) . '</em>
							</div>

						</div>
						<div class="modal-footer">
							<button class="btn btn-default ' . NNRobots_Author_Stats::$prefix_dash . 'all-time" data-dismiss="modal"><i class="fa fa-clock-o"></i> ' . __("All Time", NNRobots_Author_Stats::$text_domain) . '</button>
							<button type="submit" class="btn btn-info ' . NNRobots_Author_Stats::$prefix_dash . 'set-date" data-dismiss="modal"><i class="fa fa-filter"></i> ' . __("Apply", NNRobots_Author_Stats::$text_domain) . '</button>
							<button class="btn btn-default pull-left" data-dismiss="modal">' . __("Cancel", NNRobots_Author_Stats::$text_domain) . '</button>
						</div>
					</div>
				</div>
			</div>
		</form>

		<div class="clearfix"></div>
		<div class="' . NNRobots_Author_Stats::$prefix_dash . 'table-container"></div>
	</div>';

	return $content;

}