<?php

	//if uninstall not called from WordPress exit
	if ( !defined( 'WP_UNINSTALL_PLUGIN' ) )
		exit ();

	/* Delete all existence of this plugin */

	global $wpdb;

	$option_name = 'nnrobots_author_stats_api';
    $version_option_name = 'nnrobots_author_stats_version';
    $indexed_notice_option_name = 'nnrobots_author_stats_indexed_notice';
	$license_key_name = 'nnrobots_author_stats_license_key';

	if (!is_multisite()) {

		delete_option($option_name);
		delete_option($version_option_name);
		delete_option($license_key_name);
        delete_option($indexed_notice_option_name);

        $wpdb->query('DROP TABLE `' . $wpdb->prefix . 'nnrobots_author_stats`');
        $wpdb->query('DROP TABLE `' . $wpdb->prefix . 'nnr_as_indexed_posts`');

	    $users = get_users();

		foreach ($users as $item) {
			delete_user_meta($item->ID, 'nnrobots_ignore_notice');
		}

	} else {

		delete_site_option($option_name);
		delete_site_option($version_option_name);
		delete_site_option($license_key_name);
        delete_option($indexed_notice_option_name);

	    $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
	    $original_blog_id = get_current_blog_id();

	    foreach ( $blog_ids as $blog_id ) {
	        switch_to_blog( $blog_id );
	        $wpdb->query('DROP TABLE `' . $wpdb->prefix . 'nnrobots_author_stats`');
            $wpdb->query('DROP TABLE `' . $wpdb->prefix . 'nnr_as_indexed_posts`');
	        delete_option( $option_name );

	        $users = get_users();

			foreach ($users as $item) {
				delete_user_meta($item->ID, 'nnrobots_ignore_notice');
			}
	    }

	    // Safeguard that deletes all tables like nnrobots_author_stats

	    $item = $wpdb->get_results('SHOW TABLES LIKE "%nnrobots_author_stats"', 'ARRAY_N');

		foreach ($item[0] as $val) {
			$wpdb->query('DROP TABLE `' . $val . '`');
		}

	    switch_to_blog( $original_blog_id );
	}
?>