<?php

add_action('widgets_init', array('NNRobots_Author_Stats_Widget','register_widget'));

/**
 *
 * Main class for the Gabfire Author Stats Widget
 *
 * @since 1.0.0
 */
class NNRobots_Author_Stats_Widget extends WP_Widget {

	/**
	 * Register widget
	 *
	 * @since 1.0.0
	 *
	 * @param 	N/A
	 * @return 	N/A
	 */
	static function register_widget() {
		register_widget( 'NNRobots_Author_Stats_Widget' );
	}

	/**
	 * Register widget with WordPress.
	 */
	function __construct() {
		parent::__construct(
			NNRobots_Author_Stats::$prefix, 																						// Base ID
			'Authors Stats Pro', 																									// Name
			array( 'description' => __( 'Rank and show the best authors on your site.', NNRobots_Author_Stats::$text_domain ), ) 	// Args
		);
	}

	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	public function widget( $args, $instance ) {

		// User Roles

		global $wp_roles;
		$roles = array();

		foreach ( $wp_roles->roles as $role ) {

			$role['name'] = str_replace('|User role', '', $role['name']);

			if ( isset($role['capabilities']['edit_posts']) && $role['capabilities']['edit_posts'] ) {
				$roles[] = $role['name'];
			}

		}

		// Set default values
		if ( empty( $instance ) ) {
			$instance = NNRobots_Author_Stats::$default;
		}

		// Get Settings Data

		if (isset($instance['title'])) {
			$title = $instance['title'];
		} else {
			$title = 'Author Stats';
		}

		if (isset($instance['post_types'])) {
			$post_types = $instance['post_types'];
		} else {
			$post_types = implode(',', get_post_types(array('public' => true), 'names')) ;
		}

		if (isset($instance['user_roles'])) {
			$user_roles = $instance['user_roles'];
		} else {
			$user_roles = implode(',', $roles);
		}

		if (isset($instance['post'])) {
			$post_show = $instance['post'];
		} else {
			$post_show = true;
		}

		if (isset($instance['view'])) {
			$view_show = $instance['view'];
		} else {
			$view_show = true;
		}

		if (isset($instance['comment'])) {
			$comment_show = $instance['comment'];
		} else {
			$comment_show = true;
		}

		if (isset($instance['aggregate'])) {
			$aggregate_show = $instance['aggregate'];
		} else {
			$aggregate_show = false;
		}

		if (isset($instance['rank'])) {
			$rank = $instance['rank'];
		} else {
			$rank = '';
		}

		if (isset($instance['top'])) {
			$top = $instance['top'];
		} else {
			$top = '';
		}

		if (isset($instance['date_range'])) {
			$date_range = $instance['date_range'];
		} else {
			$date_range = '';
		}

		if (isset($instance['avatar_shape'])) {
			$avatar_shape = $instance['avatar_shape'];
		} else {
			$avatar_shape = 'rounded-square';
		}

		if (isset($instance['avatar_size'])) {
			$avatar_size = $instance['avatar_size'];
		} else {
			$avatar_size = 'large';
		}

		echo $args['before_widget'];

		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . $args['after_title'];

		$settings = get_option(NNRobots_Author_Stats::$prefix . 'settings');

		// Get settings

		if ( $settings == false ) {
			$settings = array();
		}

		include_once(NNROBOTS_AUTHOR_STATS_PLUGIN_DIR . "admin/model/db.php");

		// Get Start and End Dates

		$end_date = date(NNROBOTS_AUTHOR_STATS_DATE_FORMAT, strtotime(current_time('mysql')));

		if ( $date_range == 'all_time' ) {
			$start_date = '01/01/2001';
		} else if ( $date_range == 'year' ) {
			$start_date = date(NNROBOTS_AUTHOR_STATS_DATE_FORMAT, mktime(0, 0, 0, date("m"), date("d"), date("Y")-1));
		} else if ( $date_range == 'month' ) {
			$start_date = date(NNROBOTS_AUTHOR_STATS_DATE_FORMAT, mktime(0, 0, 0, date("m")-1, date("d"), date("Y")));
		} else if ( $date_range == 'week' ) {
			$start_date = date(NNROBOTS_AUTHOR_STATS_DATE_FORMAT, mktime(0, 0, 0, date("m"), date("d")-7, date("Y")));
		} else if ( $date_range == 'day' ) {
			$start_date = date(NNROBOTS_AUTHOR_STATS_DATE_FORMAT, mktime(0, 0, 0, date("m"), date("d")-1, date("Y")));
		}

		$authors = get_users(array(
			'who' 		=> 'authors'
		));

		foreach ( $authors as $author ) {

			$author_views[$author->ID] = NNRobots_Author_Stats_Table::get_views_by_author($author->ID, explode(',', $post_types));
		}

		// Remove users that shouldnt be there

		$valid_authors = array();

		foreach ( $authors as $author ) {
			foreach (explode(',', $user_roles) as $role) {
				if ( in_array( strtolower($role) , $author->roles) ) {
					$valid_authors[] = $author;
					break;
				}
			}
		}

		$show_authors = array();

		foreach ( $valid_authors as $author ) {

			// Avatar

			$avatar = get_avatar($author->ID, 300);

			// Get word count

			$word_count = 0;

			$posts_by_author = get_posts(array(
				'posts_per_page'	=> 500,
				'post_type'			=> explode(',', $post_types),
				'author'			=> $author->ID,
				'date_query' 		=> array(
						array(
							'after'     => isset($start_date) ? $start_date : '01/01/2001',
							'before'    => $end_date,
							'inclusive' => true,
					),
				)
			));

			foreach ( $posts_by_author as $post ) {
				$word_count += str_word_count( strip_tags($post->post_content) );
			}

			// Content

			$author_data = array(
				'id'		=> $author->ID,
				'avatar'	=> $avatar,
				'views'		=> $author_views[$author->ID],
				'posts'		=> count($posts_by_author),
				'comments'	=> (int) get_comments(array(
					'post_author' 	=> $author->ID,
					'post_type'			=> explode(',', $post_types),
					'count' 		=> true,
					'date_query' 		=> array(
							array(
								'after'     => isset($start_date) ? $start_date : '01/01/2001',
								'before'    => $end_date,
								'inclusive' => true,
						),
					)
				)),
			);


			$show_authors[] = $author_data;
		}

		// Get total columns

		$col = 0;

		if ($post_show) {
			$col++;
		}

		if ($aggregate_show) {
			$col++;
		}

		if ($view_show) {
			$col++;
		}

		if ($comment_show) {
			$col++;
		}

		// Sort

		usort($show_authors, 'nnr_sort_' . $rank);

		$show_authors = array_reverse($show_authors);

		wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'css',				NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/core/css/author-stats-pro.css');
		wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'fontawesome_css',	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/include/fontawesome/css/font-awesome.min.css');

		wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'widget_js',			NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/core/js/author-stats-widget.js');
		wp_localize_script(NNRobots_Author_Stats::$prefix . 'widget_js', 'nnr_as_widget_data', array(
			'prefix_dash'	=> NNRobots_Author_Stats::$prefix_dash,
			'ajaxurl'		=> admin_url( 'admin-ajax.php' ),
		));

		require('core/views/widget-display.php');

		echo $args['after_widget'];
	}

	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {

		$settings = get_option(NNRobots_Author_Stats::$prefix . 'settings');

		// Get settings

		if ( $settings == false ) {
			$settings = array();
		}

		// User Roles

		global $wp_roles;
		$roles = array();

		foreach ( $wp_roles->roles as $role ) {

			$role['name'] = str_replace('|User role', '', $role['name']);

			if ( isset($role['capabilities']['edit_posts']) && $role['capabilities']['edit_posts'] ) {
				$roles[] = $role['name'];
			}

		}

		// Get Settings Data

		if (isset($instance['title'])) {
			$title = $instance['title'];
		} else {
			$title = 'Author Stats';
		}

		if (isset($instance['post_types'])) {
			$post_types = $instance['post_types'];
		} else {
			$post_types = implode(',', get_post_types(array('public' => true), 'names')) ;
		}

		if (isset($instance['user_roles'])) {
			$user_roles = $instance['user_roles'];
		} else {
			$user_roles = implode(',', $roles);
		}

		if (isset($instance['post'])) {
			$post = $instance['post'];
		} else {
			$post = true;
		}

		if (isset($instance['view'])) {
			$view = $instance['view'];
		} else {
			$view = true;
		}

		if (isset($instance['comment'])) {
			$comment = $instance['comment'];
		} else {
			$comment = true;
		}

		if (isset($instance['aggregate'])) {
			$aggregate = $instance['aggregate'];
		} else {
			$aggregate = true;
		}

		if (isset($instance['rank'])) {
			$rank = $instance['rank'];
		} else {
			$rank = '1';
		}

		if (isset($instance['top'])) {
			$top = $instance['top'];
		} else {
			$top = '5';
		}

		if (isset($instance['date_range'])) {
			$date_range = $instance['date_range'];
		} else {
			$date_range = 'all_time';
		}

		if (isset($instance['avatar_shape'])) {
			$avatar_shape = $instance['avatar_shape'];
		} else {
			$avatar_shape = 'rounded-square';
		}

		if (isset($instance['avatar_size'])) {
			$avatar_size = $instance['avatar_size'];
		} else {
			$avatar_size = 'large';
		}

		wp_enqueue_style(NNRobots_Author_Stats::$prefix . 'selectize_css',	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/css/selectize.css');
		wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'selectize_js',	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/selectize.min.js');
		wp_enqueue_script(NNRobots_Author_Stats::$prefix . 'widget_js',	NNROBOTS_AUTHOR_STATS_PLUGIN_URL . '/admin/js/widget-settings.js');

		wp_localize_script(NNRobots_Author_Stats::$prefix . 'widget_js', 'nnr_as_widget_data', array(
			'prefix_dash'	=> NNRobots_Author_Stats::$prefix_dash,
			'post_types'			=> get_post_types(array('public' => true), 'names'),
			'user_roles'			=> $roles,
		));

		require('admin/views/widget-settings.php');
	}

	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title']        = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
		$instance['post_types']   = ( ! empty( $new_instance['post_types'] ) ) ? sanitize_text_field( $new_instance['post_types'] ) : '';
		$instance['user_roles']   = ( ! empty( $new_instance['user_roles'] ) ) ? sanitize_text_field( $new_instance['user_roles'] ) : '';
		$instance['post']         = ( isset( $new_instance['post'] ) && $new_instance['post'] ) ? true : false;
		$instance['view']         = ( isset( $new_instance['view'] ) && $new_instance['view'] ) ? true : false;
		$instance['comment']      = ( isset( $new_instance['comment'] ) && $new_instance['comment'] ) ? true : false;
		//$instance['aggregate']    = ( isset( $new_instance['aggregate'] ) && $new_instance['aggregate'] ) ? true : false;
		$instance['author']       = ( ! empty( $new_instance['author'] ) ) ? sanitize_text_field( $new_instance['author'] ) : '';
		$instance['editor']       = ( ! empty( $new_instance['editor'] ) ) ? sanitize_text_field( $new_instance['editor'] ) : '';
		$instance['contributor']  = ( ! empty( $new_instance['contributor'] ) ) ? sanitize_text_field( $new_instance['contributor'] ) : '';
		$instance['admin']        = ( ! empty( $new_instance['admin'] ) ) ? sanitize_text_field( $new_instance['admin'] ) : '';
		$instance['super_admin']  = ( ! empty( $new_instance['super_admin'] ) ) ? sanitize_text_field( $new_instance['super_admin'] ) : '';
		$instance['rank']         = ( ! empty( $new_instance['rank'] ) ) ? sanitize_text_field( $new_instance['rank'] ) : '';
		$instance['top']          = ( ! empty( $new_instance['top'] ) ) ? sanitize_text_field( $new_instance['top'] ) : '';
		$instance['date_range']   = ( ! empty( $new_instance['date_range'] ) ) ? sanitize_text_field( $new_instance['date_range'] ) : '';
		$instance['avatar_shape'] = ( ! empty( $new_instance['avatar_shape'] ) ) ? sanitize_text_field( $new_instance['avatar_shape'] ) : '';
		$instance['avatar_size']  = ( ! empty( $new_instance['avatar_size'] ) ) ? sanitize_text_field( $new_instance['avatar_size'] ) : '';

		return $instance;
	}

}

/**
 * Sort Authors by Views
 *
 * @access public
 * @param mixed $a
 * @param mixed $b
 * @return void
 */
function nnr_sort_views($a, $b) {
   return $a['views'] - $b['views'];
}

/**
 * Sort Authors by Posts
 *
 * @access public
 * @param mixed $a
 * @param mixed $b
 * @return void
 */
function nnr_sort_posts($a, $b) {
   return $a['posts'] - $b['posts'];
}

/**
 * Sort Authors by Views
 *
 * @access public
 * @param mixed $a
 * @param mixed $b
 * @return void
 */
function nnr_sort_comments($a, $b) {
   return $a['comments'] - $b['comments'];
}

/**
 * Sort Authors by Views
 *
 * @access public
 * @param mixed $a
 * @param mixed $b
 * @return void
 */

/**
 * Sort Authors by Views
 *
 * @access public
 * @param mixed $a
 * @param mixed $b
 * @return void
 */
function nnr_sort_aggregate($a, $b) {
   return $a['aggregate'] - $b['aggregate'];
}
